% Model sieci RLC ze zrodlem AC
% zerowe warunki poczatkowe
close all
clear all

% Parametry
R1=1;
R2=0.5;
L=0.05;
C=97E-6;
Uamp=100;   % amplituda napicia
T=0.0001;
tmax=0.04;   % okres modelowania
kmax=round(tmax/T);
% Parametry modelu sieci
GL=T/(2*L);
GC=2*C/T;
% Macierz [G]
G=[1/R1+GC+GL -GL;-GL 1/R2+GL];
G1=inv(G);  % macierz odwrotna

% warunki pocztkowe
ILk=0;  % IL(k-1)
ICk=0;  % IC(k-1)
% poczatkowy kat napiecia
fi=pi/3;

% petla zmiany czasu
for k=1:kmax
    tk(k)=T*k;      % biezacy czas
    us(k)=Uamp*cos(100*pi*tk(k)+fi);
    jR(k)=us(k)/R1;
    J=[jR(k)-ICk-ILk;ILk];
    U=G1*J;
    u1(k)=U(1);             % obliczone napiecia wezlowe
    u2(k)=U(2);
    i1(k)=jR(k)-u1(k)/R1;   % prady w galeziach
    iC(k)=u1(k)*GC+ICk;
    i2(k)=(u1(k)-u2(k))*GL+ILk;
    % obliczanie historii dla nastepnego kroku
    ICk=-iC(k)-u1(k)*GC;
    ILk=i2(k)+(u1(k)-u2(k))*GL;
end
% prady w galeziach
plot(tk,i1,'-r',tk,i2,'-b',tk,iC,'-k'); grid
legend('i1','i2','iC','Location','NorthEast')

% napiecia zrodlowe i w wezlach
figure(2)
plot(tk,us,'-r',tk,u1,'-b',tk,u2,'-k'); grid
legend('us','u1','u2','Location','NorthEast')
