% Model sieci RLC ze zrodlem AC
% Obliczenie warunkow poczatkowych w stanie ustalonym
close all
clear all

% Parametry
R1=1;
R2=0.5;
L=0.05;
C=97E-6;
Uamp=100;   % amplituda napicia
T=0.0001;
tmax=0.1;   % okres modelowania
kmax=round(tmax/T);
% Parametry modelu sieci
GL=T/(2*L);
GC=2*C/T;
% Macierz [G]
G=[1/R1+GC+GL -GL;-GL 1/R2+GL];
G1=inv(G);  % macierz odwrotna
% poczatkowy kat napiecia
fi=pi/3;
f=1.0E-8;   % czestotliwosc zrodla napieciowego

% warunki pocztkowe (rachunek zespolony)
omg=2*pi*f;
y11=1/R1+j*omg*C-j/(omg*L);
y12=j/(omg*L);
y21=y12;
%y21=real(y12)-j*imag(y12);
y22=1/R2-j/(omg*L);
Us=Uamp*(cos(fi)+j*sin(fi));
Uz=inv([y11 y12;y21 y22])*[Us/R1;0];
i2(1)=real(-(Uz(1)-Uz(2))*j/(omg*L));   % prad i2(0)
iC(1)=real(j*omg*C*Uz(1));              % prad iC(0)
u1(1)=real(Uz(1));                      % napiecie u1(0)
u2(1)=real(Uz(2));                      % napiecie u2(0)

ICk=-iC(1)-u1(1)*GC;                    % prad jC(0)
ILk=i2(1)+(u1(1)-u2(1))*GL;             % prad jL(0)

%ICk=0;
%ILk=0;

% petla zmiany czasu
for k=1:kmax
    tk(k)=T*k;      % biezacy czas
    us(k)=Uamp*cos(2*pi*f*tk(k)+fi);
    jR(k)=us(k)/R1;
    J=[jR(k)-ICk-ILk;ILk];
    U=G1*J;
    u1(k)=U(1);             % obliczone napiecia wezlowe
    u2(k)=U(2);
    i1(k)=jR(k)-u1(k)/R1;   % prady w galeziach
    iC(k)=u1(k)*GC+ICk;
    i2(k)=(u1(k)-u2(k))*GL+ILk;
    % obliczanie historii dla nastepnego kroku
    ICk=-iC(k)-u1(k)*GC;
    ILk=i2(k)+(u1(k)-u2(k))*GL;
end
% prady w galeziach
plot(tk,i1,'-r',tk,i2,'-b',tk,iC,'-k'); grid
legend('i1','i2','iC','Location','NorthEast')

% napiecia zrodlowe i w wezlach
figure(2)
plot(tk,us,'-r',tk,u1,'-b',tk,u2,'-k'); grid
legend('us','u1','u2','Location','SouthEast')
