% Przyklad2_5
% Ilustracja rozwiazania obwodu nieliniowego z Przykladu2_1
% Metoda z wykorzystaniem modelu iteracyjnego

clear all
Uamp=75;
R=50;
% warystor
q=29;
Vref=48;
ki=0.001;
Var=q*ki/Vref;
T=0.0001;
tmax=0.04;   % okres modelowania
kmax=round(tmax/T);
ii(1)=0.1;
uw(1)=60;
eps=1E-3;
fi=-pi/6;

% petla zmiany czasu
for k=1:kmax
    tk(k)=T*k;      % biezacy czas
    us(k)=Uamp*cos(100*pi*tk(k)+fi);

    del=10000;
    n=1;
    if k>1
      ii(k)=ii(k-1);
      uw(k)=uw(k-1);
    end
    u1=uw(k);
    G=Var*((u1/Vref)^(q-1));
    while del>eps,
      t(k)=n;
      ik=ii(k)-G*u1;
      uw(k)=(us(k)/R-ik)/(G+1/R);
      G=Var*((uw(k)/Vref)^(q-1));
 
      del=abs(uw(k)-u1);
      delt(k)=del;
      %[k, uw(k),del,ik],G,
      u1=uw(k);
      ii(k)=ki*(uw(k)/Vref)^q;
      n=n+1;
    end; % while
end;    % for

figure(1)
plot(tk,uw,tk,us);	% zbieno
grid
%set(gca,'XLim',[1 8]);

figure(2)
plot(tk,ii);		% denie do rozwizania
grid

figure(3)
plot(tk,t);		% denie do rozwizania
grid



