% Przyklad2_6b
% Nieliniowy przekladnik pradowy
% fi=a*atan(b(im))+cim - charakterystyka odcinkowo-liniowa

clear all
close all

ts=0.0001;          % krok modelowania
t1=0.02;
a=2*pi*ts/t1;
ta=0.02;
nt=5;
nm=nt*t1/ts;
% charakterystyka magnesowania
am=0.9009; bm=14.2; cm=0.0012;
Im1=0.10076;    Lm1=12.8;
Im2=4.0;        Lm2=0.13808;
%Im1=0.2;        Lm1=5.552;
%Im2=4.0;        Lm2=0.07729;
Im3=150;        Lm3=1.30548e-3;

% obciazenie RL
R=8;
L=0.01;
glr=ts/(2*L+R*ts);
klr=(2*L-R*ts)/(2*L+R*ts);

% warunki poczatkowe
im(1)=0;
jm(1)=0;
u1(1)=10;           % napiecie w wezle 1
ilr(1)=0;
lm=10;              % indukcyjnosc L
eps=1e-4;           % granica zbieznosci
ngr=35;             % max. liczba iteracji

lm=cm+am*bm/(1+(bm*im(1))^2);
gm(1)=ts/(2*lm);

% petla czasowa
for i=1:nm,
 if i>1,
  u1(i)=u1(i-1);    % przeniesienie wartosci z poprzedniego kroku
  im(i)=im(i-1);
  ilr(i)=ilr(i-1);
  gm(i)=gm(i-1);
 end
 t(i)=(i-1)*ts;     % czas
 jlr(i)=klr*ilr(i)+glr*u1(i);
 jm(i)=im(i)+gm(i)*u1(i);
 i1(i)=-100*(cos(a*(i-1))-exp(-(i-1)*ts/(ta)));	% zrodlo pradowe
 is=i1(i)-jlr(i)-jm(i);         % prad wezla (Iz)
 
 del=100;
  % petla iteracyjna
 n=0;
 ig=im(i)-jm(i);
 while (del>eps)&(n<ngr),       % warunek zbieznosci
  n=n+1;
  gz=gm(i)+glr;

  Imn(i)=ig-gm(i)*u1(i);
  Iz(i)=is-Imn(i);
  u10=Iz(i)/gz;
  del=abs(u1(i)-u10);
  u1(i)=u10;
  im(i)=gm(i)*u1(i)+jm(i);
  % okreslenie indukcyjnosci Lm
  aIm=abs(im(i));
  if aIm>Im2,
      lm=Lm3;
   elseif aIm>Im1,
      lm=Lm2;
    else
      lm=Lm1;
  end;
%  lm=cm+am*bm/(1+(bm*im(i))^2);
  gm(i)=ts/(2*lm);
  ig=gm(i)*u1(i);
  lp(i)=lm;
 end;   % while
 ilr(i)=glr*u1(i)+jlr(i);       % prad obciazenia RL
 itern(i)=n;
end;

plot(t,i1,'-r',t,ilr,'-b',t,im,'--m');
grid

figure
semilogy(t,lp,'-r',t,itern,'--b');
%plot(t,lp,'-r');
grid



