function [h,d]=S_G_filtr(M,N,m)
% Obliczanie wspolczynnikow filtru wygladzajacego i rozniczkujacego
% wg metody Savitzky-Golay
%       [h,d]= S_G_filtr(x,M,N,m)
%       M    = liczba probek w oknie pomiarowym
%       N    = stopien wielomianu aproksymacyjnego
%       m    = nr probki w oknie, wzgledem ktorej liczony jest sygnal
%              wyjsciowy: m = (1, 2, ..., M)
%       h    = wspolczynniki uzyskanego filtru gladzacego
%       d    = wspolczynniki uzyskanego filtru rozniczkujacego

 N=N+1;
 nL=m-1;
 nP=M-m;

 % sprawdzenie warunkow
 if (nL<0)|(nP<0)|(nL+nP<N),
   disp('zle zdefiniowany filtr'); return;
 end;
 for i=1:N,
  for j=1:N,
   aa(i,j)=0;
   for k=-nL:nP,
    aa(i,j)=aa(i,j)+k^(i+j-2);
   end,
  end,
 end;
 p=inv(aa);
 % wspczynniki funkcji aproksymacyjnej
 b=p(1,:);          % pierwszy wiersz macierzy p
 for n=1:M,
  h(n)=0;           % wspolczynniki filtru wygladzajacego
  for j=1:N,
   h(n)=h(n)+b(j)*(n-nL-1)^(j-1);
  end;
 end;
% wspczynniki pochodnej
 b=p(2,:);          % drugi wiersz macierzy p
 for n=1:M,
  d(n)=0;          % wspolczynniki filtru pochodnej
  for j=1:N,
   d(n)=d(n)+b(j)*(n-nL-1)^(j-1);
  end;
 end;
