% Przyklad z uzyciem funkcji S_G_filtr:
% Obliczanie wspolczynnikow filtru wygladzajacego i rozniczkujacego
% wg metody Savitzky-Golay
%       [h,d]= S_G_filtr(M,N,m)

 clear all
 close all

 M=9;   % liczba probek w oknie pomiarowym
 m=5;   % nr probki w oknie, wzgledem ktorej liczony jest sygnal wyjsciowy:
        % m = (1, 2, ..., M)
 N=2;   % stopien wielomianu aproksymacyjnego
 
 [h,d]=S_G_filtr(M,N,m);

 % obliczenie cakowitych wspczynnikw filtru gladzacego: c1
 k=0;
 [n,i]=min(abs(h));
 p1=h;
 if n<1e-10, p1(i)=1e10; end;
 [n,i]=min(abs(p1));
 l1=floor(1/n);
 n=size(h,2);
 while ~k,
  i=0;
  while i<n,
   i=i+1;
   p=h(i)*l1;
   if abs(p-round(p))>1e-5, l1=l1+1; k=0; i=n+1;
    else, k=1;
   end;
  end;
 end;

% obliczenie cakowitych wspczynnikw filtru pochodnej: c2
 k=0; 
 [n,i]=min(abs(d));
 p1=d;
 if n<1e-10, p1(i)=1e10; end;
 [n,i]=min(abs(p1));
 l2=floor(1/n);
 n=size(d,2);
 while ~k,
  i=0;
  while i<n,
   i=i+1;
   p=d(i)*l2;
   if abs(p-round(p))>1e-5, l2=l2+1; k=0; i=n+1;
    else, k=1;
   end;
  end;
 end;

['Wspolczynniki filtrw:'],
[l1*h;l2*d],
[l1;l2],

%  generacja sygnalu wejciowego
nm=50;          % liczba probek sygnalu
nP=M-m;
n=20;
a=2*pi/n;
nm=nm+nP;
for i=1:nm,
 s1(i)=1+0.5*(1-rand(1))+sin(0.2*a*i);
 s1(i)=5*(1+0.5*(1-rand(1)))+3*atan(a*i-8);
s1(i)=5*(1+1*(1-rand(1)))+3*atan(a*i-8); 
 if i>=M,
   x1(i)=h*s1((i-M+1):i)';
   x2(i)=d*s1((i-M+1):i)';
  else,
   x1(i)=0;
   x2(i)=0;
 end;
 t(i)=i-1;
end;
 xp=x1(1:nm-nP);
 x1=x1(nP+1:nm);
 x2=x2(1:nm-nP);
 s1=s1(1:nm-nP);
 t=t(nP+1:nm)-nP;

 figure(1)
 subplot(2,1,1);
 plot(t,s1,'+b',t,x1,'.r',t,xp,'.g'); hold on;
 plot(t,s1,'b',t,x1,':r',t,xp);
 grid;
 subplot(2,1,2);
 plot(t,x2,'.m'); hold on;
 plot(t,x2,'g');
 grid;

 

