% Program do Przykadu 1.3
% 
% MATLAB wersja 5.3 i wyej

clear all
T=5*1e-5;			% krok modelowania
tmx=0.1;			% okres modelowania

% parametry
f=50;				% czstotliwo rda
omg=2*pi*f;
q=omg*T;			% kt pomidzy prbkami napicia zasilajcego
es=330000;			% amplituda napicia zasilajcego
zs=0.5+10i;			% impedancja systemu
z1=4700+2800i;			% impedancja Z1
z2=415+200i;			% impedancja Z2
Rl=0.0288;			% parametry linii: R', L', C'
Ll=1.0287*1e-3;			% L, H/km
Cl=11.232*1E-9;			% C, F/km
l=180;				% dugo linii
l1=imag(z1)/omg;		% indukcyjno 	L1
l2=imag(z2)/omg;		% 		L2
ls=imag(zs)/omg;		% 		Ls

R1=real(z1);
G1=T/(2*l1);
Gz1=T/(2*l1+T*R1);		% Gz1
R2=real(z2);
G2=T/(2*l2);
Gz2=T/(2*l2+T*R2);		% Gz2
Rs=real(zs);
Gs=T/(2*ls);
Gzs=T/(2*ls+T*Rs);		% Gzs
zf=sqrt(Ll/Cl);			% Parametry modelu linii: Zf
Rl=l*Rl;			% 			  R
Gf=1/(zf+Rl/2);			% 			  Gf
m=round(l*sqrt(Ll*Cl)/T);
hf=(2*zf-Rl)/(2*zf+Rl);

Gw=1.0e9;			% Gw

% macierz G
Gaa=[Gz2+Gf 0 0; 0 Gf+Gw -Gw; 0 -Gw Gz1+Gzs+Gw];
Gab=[0;0;-Gzs];
Gba=Gab';
Gbb=Gzs;
G=[Gaa Gab;Gba Gbb];

fi=0;				% faza pocztkowa napicia zasilajcego
jL1=zeros(1,m);
jL2=jL1;
jz1(1)=0;
jz2(1)=0;
jzs(1)=0;

% ptla symulacji stanu przejciowego
n=0;				% indeks w rejestrach jL1 oraz jL2
U(:,1)=[0;0;0;es*cos(fi)];
Ib=0;
is(1)=0;
k=0;
t(1)=0;

while tmx>k*T

 % przesuniecie czasu
 l=k;
 if ~l
  l=1;
 end
 k=k+1;
 t(k)=(k-1)*T;
 n=n+1;
 if n>m
  n=1;
 end

%[k n jL1(n) jL2(n)],

 Ia=[-jz2(l)-jL2(n);-jL1(n);jzs(l)-jz1(l)];
 Ub=es*cos((k-1)*q+fi);
 Ua=inv(Gaa)*(Ia-Gab*Ub);
 Ib=Gba*Ua+Gbb*Ub;
 U(:,k)=[Ua;Ub];

 iL1(k)=Gf*U(2,k)+jL1(n);
 iL2(k)=Gf*U(1,k)+jL2(n);
 jL1(n)=-(Gf*U(1,k)+hf*iL2(k));
 jL2(n)=-(Gf*U(2,k)+hf*iL1(k));

 iz1(k)=jz1(l)+Gz1*U(3,k);
 iz2(k)=jz2(l)+Gz2*U(1,k);
 is(k)=Ib+jzs(l);
 jzs(k)=((1-Rs*Gs)*is(k)+Gs*(U(4,k)-U(3,k)))/(1+Rs*Gs);
 jz1(k)=((1-R1*G1)*iz1(k)+G1*U(3,k))/(1+R1*G1);
 jz2(k)=((1-R2*G2)*iz2(k)+G2*U(1,k))/(1+R2*G2);
end	% while tmx

plot(t,U(2,:));
grid
figure
plot(t,iL1);
grid

