% Przykad 1.4
% Modelowanie stanu przejsciowego w sieci z warunkami poczatkowymi
% odpowiadajcymi stanowi ustalonemu

clear all
T=5*1e-5;			% krok modelowania
tmx=0.1;			% okres modelowania
tzw=0.022;			% moment zwarcia

% parametry
f=50;				% czstotliwo rda
omg=2*pi*f;
q=omg*T;			% kt pomidzy prbkami napicia zasilajcego
es=330000;			% amplituda napicia zasilajcego
zs=0.5+10i;			% impedancja systemu
z1=4700+2800i;			% impedancja Z1
z2=415+200i;			% impedancja Z2
Rl=0.0288;			% parametry linii: R', L', C'
Ll=1.0287*1e-3;			% L, H/km
Cl=11.232*1E-9;			% C, F/km
l=180;				% dugo linii
Rzw=1;				% rezystancja zwarcia
m=round(l*sqrt(Ll*Cl)/T);

% ustalenie parametrw modelu
jw=j*omg;
gam=l*sqrt((Rl+jw*Ll)*jw*Cl);
yl=1/(l*(Rl+jw*Ll)*sinh(gam)/gam);
yp2=l*jw*Cl*tanh(gam/2)/gam;
ya=yp2+1/z1;
yb=yp2+1/z2;
ys=1/zs;
p=(ys+ya)*(yb+yl)+yb*yl;
u2=es*ys*(yb+yl)/p;
u1=ys*yl*es/p;
i1=ys*(es-u2);
io1=u2/z1;
io2=u1/z2;

l1=imag(z1)/omg;		% indukcyjno 	L1
l2=imag(z2)/omg;		% 		L2
ls=imag(zs)/omg;		% 		Ls

R1=real(z1);
G1=T/(2*l1);
Gz1=T/(2*l1+T*R1);		% Gz1
R2=real(z2);
G2=T/(2*l2);
Gz2=T/(2*l2+T*R2);		% Gz2
Rs=real(zs);
Gs=T/(2*ls);
Gzs=T/(2*ls+T*Rs);		% Gzs
zf=sqrt(Ll/Cl);			% Parametry modelu linii: Zf
Rl=l*Rl;			% 			  R
Gf=1/(zf+Rl/2);			% 			  Gf
hf=(2*zf-Rl)/(2*zf+Rl);

% obliczanie stanu ustalonego
% linia
 for k=1:m,
  l=k-1;
  p=exp(-l*jw*T);
  iL1=real((i1-io1)*p);
  iL2=-real((io2)*p);
  U1=real(u1*p);
  U2=real(u2*p);
  jL1(1,m-l)=-(Gf*U1+hf*iL2);
  jL2(1,m-l)=-(Gf*U2+hf*iL1);
 end
% inne
 p=exp(-jw*T);
 jzs(1)=((1-Rs*Gs)*real(i1*p)+Gs*real((es-u2)*p))/(1+Rs*Gs);
 jz1(1)=((1-R1*G1)*real(io1*p)+G1*real(u2*p))/(1+R1*G1);
 jz2(1)=((1-R2*G2)*real(io2*p)+G2*real(u1*p))/(1+R2*G2);

Gzw=1/Rzw;			% przewodno zwarcia

% macierz G
Gaa=[Gz2+Gf 0; 0 Gz1+Gzs+Gf];
Gab=[0;-Gzs];
Gba=Gab';
Gbb=Gzs;
G=[Gaa Gab;Gba Gbb];

fi=0;				% faza pocztkowa napicia zasilajcego

% ptla symulacji stanu przejciowego
n=0;				% indeks w rejestrach jL1 oraz jL2
U(:,1)=[0;0;es*cos(fi)];
Ib=0;
is(1)=0;
k=0;
t(1)=0;

kzw=round(tzw/T);		% krok zwarcia

while tmx>k*T

 % przesuniecie czasu
 l=k;
 if ~l
  l=1;
 end
 k=k+1;
 t(k)=(k-1)*T;
 n=n+1;
 if n>m
  n=1;
 end
 % zwarcie
 if k==kzw,
  Gaa(1,1)=Gz2+Gf+Gzw;
 end

 Ia=[-jz2(l)-jL2(n);jzs(l)-jL1(n)-jz1(l)];
 Ub=es*cos((k-1)*q+fi);
 Ua=inv(Gaa)*(Ia-Gab*Ub);
 Ib=Gba*Ua+Gbb*Ub;
 U(:,k)=[Ua;Ub];

 iL1(k)=Gf*U(2,k)+jL1(n);
 iL2(k)=Gf*U(1,k)+jL2(n);
 jL1(n)=-(Gf*U(1,k)+hf*iL2(k));
 jL2(n)=-(Gf*U(2,k)+hf*iL1(k));

 iz1(k)=jz1(l)+Gz1*U(2,k);
 iz2(k)=jz2(l)+Gz2*U(1,k);
 is(k)=Ib+jzs(l);
 jzs(k)=((1-Rs*Gs)*is(k)+Gs*(U(3,k)-U(2,k)))/(1+Rs*Gs);
 jz1(k)=((1-R1*G1)*iz1(k)+G1*U(2,k))/(1+R1*G1);
 jz2(k)=((1-R2*G2)*iz2(k)+G2*U(1,k))/(1+R2*G2);

end	% while tmx

% save some results
p=[t' U(2,:)'];
save u2 p -V4
p=[t' iL1'];
save il1 p -V4

plot(t,U(2,:));
grid
figure;
plot(t,iL1);
grid

