% Przyklad2_3
% Ilustracja rozwiazywania obwodu nieliniowego
% Metoda Newtona dla rownania napiciowego

clear all
% parametry obwodu - patrz Rys. 2.1
u=60;           % napiecie zasilajace [V]
R=50;           % rezystancja opornika R
% warystor
q=29;           % wykladnik
uref=48;        % [V]
ki=0.001;       % [A]
eps=1E-5;       % przedzial zbieznosci (dokladnosc)

del=10000;      % poczatkowa granica bledu
k=1;            % numer iteracji
u1=1;           % poczatkowa wartosc napiecia na warystorze
p=1/q;
% petla obliczen iteracyjnych
while del>eps,
 t(k)=k;        % numer kroku (tylko do wykresu)
 iw(k)=R*ki*(u1/uref)^(q-1);
 uwp=-iw(k)*q/uref-1;       % pochodna napiecia na warystorze
 % rownanie Newtona (napiecie na warystorze)
 uw(k)=u1-(u-u1*(iw(k)/uref+1))/uwp;

 del=uw(k)-u1;  % sprawdzenie zbieznosci, [V]
 delt(k)=del;   % tylko do wykresu
 %del=del/R;     % sprawdzenie zbieznosci [A]
 [k, uw(k),del],
 del=abs(del);
 k=k+1;
 u1=uw(k-1);
 if k==9, del=0; end    % max. liczba iteracji
end; % while

plot(t,uw,t,delt);
grid
%set(gca,'XLim',[1 5]);


