% Przyklad2_3
% Ilustracja rozwiazania obwodu nieliniowego
% Metoda Newtona dla rownania prdowego

clear all
% parametry obwodu - patrz Rys. 2.1
u=60;           % napiecie zasilajace [V]
R=50;           % rezystancja opornika R
% warystor
q=29;           % wykladnik
uref=48;        % [V]
ki=0.001;       % [A]
eps=1E-5;       % przedzial zbieznosci (dokladnosc)

del=10000;      % poczatkowa granica bledu
k=1;
i1=1;           % poczatkowa wartosc pradu [A]
p=1/q;
% petla iteracyjna
while del>eps,  % warunek zbieznosci
 t(k)=k;
 % tworzenie rownania pradowego
 iw(k)=(uref*(abs(i1)/ki)^p);
 iwp(k)=-p*iw(k)/abs(i1)-R;
 % nowa wartosc pradu
 iw(k)=i1-(u-iw(k)-R*i1)/iwp(k);
 del=abs(iw(k)-i1);     % sprawdzenie zbieznosci
 delt(k)=del;
 [k, iw(k),del],
 k=k+1;                 % przygotowanie do kolejnej iteracji
 i1=iw(k-1);            % nowa wartosc poczatkowa pradu
end; % while

%plot(t,iw,t,delt,t,iwp);
plot(t,iw,t,delt);
grid
set(gca,'XLim',[1 5]);


