% Przyklad2_5
% Ilustracja rozwiazania obwodu nieliniowego z Przykladu2_1
% Metoda z wykorzystaniem modelu iteracyjnego

clear all
close all
% parametry obwodu - patrz Rys. 2.1
u=60;           % napiecie zasilajace [V]
R=50;           % rezystancja opornika R
% warystor
q=29;           % wykladnik
uref=48;        % [V]
ki=0.001;       % [A]
eps=1E-5;       % przedzial zbieznosci (dokladnosc)

del=10000;      % poczatkowa granica bledu
k=1;
u1=60;
g=q*ki*((u1/uref)^(q-1))/uref;  % poczatkowa przewodnosc warystora
ii=0.1;                         % poczatkowy prad warystora
% petla iteracyjna
while del>eps,
 t(k)=k;
 ik=ii-g*u1;
 uw(k)=(u/R-ik)/(g+1/R);        % napiecie na warystorze
 g=q*ki*((uw(k)/uref)^(q-1))/uref;
 
 del=abs(uw(k)-u1);             % sprawdzenie zbieznosci
 delt(k)=del;
 [k, uw(k),del,ik,g],
 u1=uw(k);
 ii=ki*(u1/uref)^q; % prad warystora
 iik(k)=ii;
 k=k+1;
end; % while

plot(t,uw,t,delt);	% zbieno
grid

figure
plot(uw,iik);		% denie do rozwizania
grid



