% Nieliniowy przekladnik
% fi=a*atan(b(im))+cim
% calkowanie wg metody Geara II rzedu

clear all
close all

ts=0.00002;
t1=0.02;
a=2*pi*ts/t1;
ta=0.02;
ampl=500;		% magnitude of I1
nt=5;
nm=nt*t1/ts;
% charakterystyka magnesowania
am=0.9009; bm=14.2; cm=0.0012;

% RL
R=8;
L=0.01;
glr=2*ts/(3*L+2*R*ts);
klr=L/(3*L+2*R*ts);

% warunki poczatkowe
im(1)=0;
jm(1)=0;
jlr(1)=0;
u1(1)=10;
ilr(1)=0;
lm=10;
eps=1e-6;
ngr=35;

lm=cm+am*bm/(1+(bm*im(1))^2);
gm(1)=2*ts/(3*lm);

% petla czasowa
for i=1:nm,
 if i>2,
   u1(i)=u1(i-1);
   ilr(i)=ilr(i-1);
   jlr(i)=klr*(4*ilr(i-1)-ilr(i-2));
   gm(i)=gm(i-1);
   jm(i)=(4*im(i-1)-im(i-2))/3;
   im(i)=gm(i)*u1(i)+jm(i);
  elseif i>1,
   u1(i)=u1(i-1);
   ilr(i)=ilr(i-1);
   jlr(i)=klr*4*ilr(i-1);
   gm(i)=gm(i-1);
   jm(i)=4*im(i-1)/3;
   im(i)=gm(i)*u1(i)+jm(i);
 end
 t(i)=(i-1)*ts;

 i1(i)=-ampl*(cos(a*(i-1))-exp(-(i-1)*ts/(ta)));
 is=i1(i)-jlr(i)-jm(i);
 
 del=100;
  % petla iteracyjna
 n=0;
 ig=im(i)-jm(i);		% prad w nieliniowej przewodnosci
 while (del>eps)&(n<ngr),
  n=n+1;
  gz=gm(i)+glr;
  Imn=ig-gm(i)*u1(i);
  Iz=is-Imn;
  u10=Iz/gz;			% wg metody potencjalow wezlowych
  del=abs(u1(i)-u10);
  u1(i)=u10;
  im(i)=gm(i)*u1(i)+jm(i);
  lm=cm+am*bm/(1+(bm*im(i))^2);
  gm(i)=2*ts/(3*lm);
  ig=gm(i)*u1(i);		% skorygowana wartosc pradu
 end;	% while (del>eps)&(n<ngr),
 if n==ngr,
  [del Imn],
 end;
 lp(i)=lm;
 ilr(i)=glr*u1(i)+jlr(i);
end;	% for i=1:nm,

plot(t,i1,t,ilr);
grid

figure
plot(t,im);
grid

figure
semilogy(t,lp);
grid

