% Nieliniowy uklad z ferrorezonansem
% fi=am*atan(bm*(im))+cm*im
% metoda kompensacji


clear all
ts=0.00001;
ts2=ts/2;
t1=0.02;	% okres przebiegu
a=2*pi*ts/t1;
ta=0.02;
nt=12;
nm=nt*t1/ts;
% charakterystyka magnesowania
am=17.8289;
bm=7.5;
cm=0.0149;
ba2=2*bm/am;

% parametry
Rs=0.4;
Ls=0.024;
Cg1=8.7E-9;
Cg2=120.0E-9;
Cs=22.E-9;
Rp=0.2;
Lp=0.005;
Rn=2.4E6;
U=8300;
fi=0;

gls=ts/(2*Ls+Rs*ts);
kls=(2*Ls-Rs*ts)/(2*Ls+Rs*ts);
glp=ts/(2*Lp+Rp*ts);
klp=(2*Lp-Rp*ts)/(2*Lp+Rp*ts);
gc1=2*Cg1/ts;
gc2=2*Cg2/ts;
gcs=2*Cs/ts;
gn=1/Rn;

% warunki poczatkowe
is=0; js=0;
ic1=0; jc1=0;
ic2=0; jc2=0;
ics=0; jcs=0;
ip=0; jp=0;
im=0; jm=0;
us=0;

ji=[js-jc1-jcs jcs-jc2-jp jp]';
Gaa=[gc1+gls+gcs -gcs 0;-gcs gc2+gcs+glp -glp;0 -glp gn+glp];
Gba=[-gls 0 0];
Gab=Gba';
u1=0; u2=0; u3=0;
is=0;

% Obliczenie Rt
Gp=inv(Gaa);
rr=Gp(:,3);
Rt=rr(3,1);

eps=1e-4;
ngr=20;	% max. liczba iteracji

 disp('Wait a moment...');

% petla czasowa
for i=1:nm,

 t(i)=(i-1)*ts;
 us=U*sin(a*(i-1)+fi);
 js=kls*is+gls*(us-u1);
 jcs=-ics-gcs*(u1-u2);
 jc1=-ic1-gc1*u1;
 jc2=-ic2-gc2*u2;
 jp=klp*ip+glp*(u2-u3);
 ja=[js-jc1-jcs;jcs-jc2-jp;jp];

 ua0=Gp*(ja-Gab*us);
 Et=ua0(3,1);

 del=100;
  % petla iteracyjna
 n=0;
 while (del>eps)&(n<ngr),
  um=Et-Rt*im;
  lm=cm+am*bm/(1+(bm*im)^2);
  fim=im-ts2*um/lm-jm;
  p=(lm-cm)/lm;
  fmp=1+ts2*(Rt/lm-ba2*p*p*um*im);
  del=fim/fmp;
  im=im-del;
  del=abs(del);
  n=n+1;
 end;
 if n==ngr,
  del,
 end;
%[t(i) lm im Imn n], %pause;

 % korekcja napiecia
 ua=ua0-rr*im;
 u1=ua(1);
 u2=ua(2);
 u3=ua(3);

 % prdy
 is=gls*(us-u1)+js;
 ic1=gc1*u1+jc1;
 ics=gcs*(u1-u2)+jcs;
 ic2=gc2*u2+jc2;
 ip=glp*(u2-u3)+jp;
 gm=ts2/lm;
 jm=im+gm*u3;
 
 iis(i)=is;
 iics(i)=ics;
 uu3(i)=u3;
 uu2(i)=u2;
 uu1(i)=u1;
 iim(i)=im;
 iic2(i)=ic2;
 iip(i)=ip;
 uss(i)=us;
 nng(i)=n;
 Ept(i)=Et;
end;

%plot(t,iis,t,iics,t,iim);
plot(t,iics,t,iim,t,iic2,t,iip);
grid
%set(gca,'XLim',[1 20]);

figure
plot(t,uss,t,uu3,t,uu2);
grid

figure
plot(t,Ept);
grid


