% program for presentation of the line frequency characteristic
% contained in *.lis file


    NEWL=abs([13 10]);
    [getfile,pat] = uigetfile('*.lis','Get Data File for Modification');
    if getfile == 0, return; end;
    k=size(pat);
    FILEPATH=pat(1:(k(2)-1));
    FILENAME=getfile;
    fid=fopen([pat getfile]);
    MFILE=fread(fid);
    MFILE=sprintf('%s',MFILE);
    k=findstr(MFILE,' Neper/km  ');
    l1=size(k,2);
    l2=size(MFILE,2);
    MFILE=MFILE(k(1,l1):l2);
    k=findstr(MFILE,NEWL);
    l1=size(k,2);
    l2=1;
    m=1;
    while l2,
     if l1>2,
       p=str2num(MFILE(k(1,m)+2:k(1,m+1)));
       if ~isempty(p),   
         nn(m,:)=p;
         m=m+1;
        else,
         l2=0;
       end;
      else,
       ['error'], return;
     end;
    end;
% Results:
%  --------------  Zero sequence  ----------------              -------------  Positive sequence  -------------
%    Alpha        Beta        R        L(milli-    C(micro-      Alpha        Beta        R        L(milli-    C(micro-    Frequency
% Neper/km    Radian/km    Ohm/km    Henry/km)   Farad/km)    Neper/km    Radian/km    Ohm/km     Henry/km)   Farad/km)       Hz
%
    k=size(nn,1);
    nn=nn(1:k-5,:);
    f=nn(:,11);
    % plotting R
    loglog(f,nn(:,3),f,nn(:,8));
%    semilogx(f,nn(:,3),f,nn(:,8));
    title('Resistance');
    grid;
    figure;
    % plotting L
    loglog(f,nn(:,4),f,nn(:,9));
    semilogx(f,nn(:,4),f,5*nn(:,9));
    title('Inductance');
    grid;


