% program for presentation of the line frequency characteristic
% contained in *.lis file

clear all;

    NEWL=abs([13 10]);
    [getfile,pat] = uigetfile('*.lis','Get Data File for Modification');
    if getfile == 0, return; end;
    k=size(pat);
    FILEPATH=pat(1:(k(2)-1));
    FILENAME=getfile;
    fid=fopen([pat getfile]);
    MFILE=fread(fid);
    MFILE=sprintf('%s',MFILE);
    k=findstr(MFILE,' Neper/km  ');
    l1=size(k,2);
    l2=size(MFILE,2);
    MFILE=MFILE(k(1,l1):l2);
    k=findstr(MFILE,NEWL);
    l1=size(k,2);
    l2=1;
    m=1;
    while l2,
     if l1>2,
       p=str2num(MFILE(k(1,m)+2:k(1,m+1)));
       if ~isempty(p),   
         nn(m,:)=p;
         m=m+1;
        else,
         l2=0;
       end;
      else,
       ['error'], return;
     end;
    end;
% Results:
%  --------------  Zero sequence  ----------------              -------------  Positive sequence  -------------
%    Alpha        Beta        R        L(milli-    C(micro-      Alpha        Beta        R        L(milli-    C(micro-    Frequency
% Neper/km    Radian/km    Ohm/km    Henry/km)   Farad/km)    Neper/km    Radian/km    Ohm/km     Henry/km)   Farad/km)       Hz
%
    k=size(nn,1);
%    nn=nn(1:k-5,:);
    f=nn(:,11);
    omt=2*pi*f;
    % A(w)
    ll=180;	% dlugosc linii, km
    j=sqrt(-1);
    gg=0.03*1E-6;
    aw0=exp(-(nn(:,1)+j*nn(:,2))*ll);
    z0=(nn(:,3)+j*omt.*nn(:,4)/1000);
    y0=gg+j*omt.*nn(:,5)/1E6;
    zf0=sqrt(z0./y0);
    aw1=exp(-(nn(:,6)+j*nn(:,7))*ll);
    z1=(nn(:,8)+j*omt.*nn(:,9)/1000);
    y1=gg+j*omt.*nn(:,10)/1E6;
    zf1=sqrt(z1./y1);
    k_t0=find(abs(aw0)<0.01);
    k_t0=k_t0(1);
    tf0=ll*nn(k_t0,2)/omt(k_t0);
    arp0=omt*tf0-ll*nn(:,2);
    k_t1=find(abs(aw1)<0.01);
    k_t1=k_t1(1);
    tf1=ll*nn(k_t1,7)/omt(k_t1);
    arp1=omt*tf1-ll*nn(:,7);
    semilogx(f,arp0,f,arp1);
    set(gca,'YLim',[-2 0.1]);
    title('arg(P(w))');
    grid;
     % Zf
    figure;
    semilogx(f,abs(zf0),f,abs(zf1));
    title('|Zf(w)|');
    grid;
    figure;
    % plotting Zf
    semilogx(f,180*unwrap(angle(zf0))/pi,f,180*unwrap(angle(zf1))/pi);
    title('arg(Zf(w))');
    grid;


