% synteza acucha dwjnikw RC dla skadowej zerowej
% na podstawie danych ze zbioru *.lis

clear all

    NEWL=abs([13 10]);
    [getfile,pat] = uigetfile('*.lis','Get Data File for Modification');
    if getfile == 0, return; end;
    k=size(pat);
    FILEPATH=pat(1:(k(2)-1));
    FILENAME=getfile;
    fid=fopen([pat getfile]);
    MFILE=fread(fid);
    MFILE=sprintf('%s',MFILE);
    k=findstr(MFILE,' Neper/km  ');
    l1=size(k,2);
    l2=size(MFILE,2);
    MFILE=MFILE(k(1,l1):l2);
    k=findstr(MFILE,NEWL);
    l1=size(k,2);
    l2=1;
    m=1;
    while l2,
     if l1>2,
       p=str2num(MFILE(k(1,m)+2:k(1,m+1)));
       if ~isempty(p),   
         nn(m,:)=p;
         m=m+1;
        else,
         l2=0;
       end;
      else,
       ['error'], return;
     end;
    end;
% Results:
%  --------------  Zero sequence  ----------------              -------------  Positive sequence  -------------
%    Alpha        Beta        R        L(milli-    C(micro-      Alpha        Beta        R        L(milli-    C(micro-    Frequency
% Neper/km    Radian/km    Ohm/km    Henry/km)   Farad/km)    Neper/km    Radian/km    Ohm/km     Henry/km)   Farad/km)       Hz
%
    ll=180;	% dlugosc linii
    k=size(nn,1);
k=find(exp(-ll*nn(:,1))<0.001);
k=k(1),
%nn=nn(1:k,:);
    f=nn(:,11);
    omg=2*pi*f;
    gg=0.03*1E-6;
  
     % A(w)
    j=sqrt(-1);
    aw0=exp(-(nn(:,1)+j*nn(:,2))*ll);
    z0=(nn(:,3)+j*omg.*nn(:,4)/1000);
    y0=gg+j*omg.*nn(:,5)/1E6;
    aw0=exp(-sqrt(z0.*y0)*ll);
    zf0=sqrt(z0./y0);
    aw1=exp(-(nn(:,6)+j*nn(:,7))*ll);
    z1=(nn(:,8)+j*omg.*nn(:,9)/1000);
    y1=j*omg.*nn(:,10)/1E6;
    zf1=sqrt(z1./y1);

    % charakterystyka amplitudy funkcji propagacji
    semilogx(f,abs(zf0),f,abs(zf1));
    title('|Zf(w)|');
    grid;
 
     % aproksymacja dla skladowej zerowej

wgt = 0.8;
wgtg = frsp(wgt,f);
vaw0=vpck(abs(zf0),f);		% wspolczynniki wagowe
sysfit = fitmag(vabs(vaw0),wgtg);
[a,b,c,d]=unpck(sysfit);
[num,den]=ss2tf(a,b,c,d);

figure;
 semilogx(f,abs(polyval(num,j*f)./polyval(den,j*f)));
 title('NUM/DEN');
grid;

% obliczanie zer i biegunw z num/den
z1=roots(num);
p1=roots(den);

gain=num(1)/den(1);
% sprawdzenie
sys2 = zp2sys(z1,p1,gain);
figure;
sysf = frsp(sys2,f);
msys=vunpck(sysf);
    semilogx(f,abs(zf0),f,abs(msys),f,abs(polyval(num,j*f)./polyval(den,j*f)));
    title('|Zf0(w)|');
grid;

figure;
    semilogx(f,180*angle(zf0)/pi,f,180*angle(msys)/pi);
    title('arg(Zf0(w))');
grid;

	% obliczenie parametrw
	num1=num;
	den1=den;
	[gain,r]=deconv(num1,den1);	% dzielenie licznika przez mianownik
	z2=z1;
	p2=p1;
	lb=size(den1,2)-1;
	wym=lb;
	for i=1:lb,
	 li(i)=polyval(num1,p2(i));
	 mn(i)=1;
 	 for l=1:lb,
	  if l~=i,
	   mn(i)=mn(i)*(p2(i)-p2(l));
	  end; 
	 end;
	 k2(i)=li(i)/mn(i);
	 r2(i)=-k2(i)/p2(i);
	 c2(i)=1/k2(i);
	end;
	k2=k2(1:wym),
	r2=r2(1:wym),
	c2=c2(1:wym)*1.E6,
	gain,

% sprawdzenie
nw=200;
f_0=1E-3;
f_1=1E6;
p_0=log10(f_0);
p_1=log10(f_1);
nf=p_1-p_0;
lf=nf/(nw-1);
for l=1:nw,
 f(l)=10^(p_0+(l-1)*lf);
 x=j*f(l);
 w1(l)=polyval(num,x)/polyval(den,x);
 w2(l)=gain+k2(1)/(x-p1(1))+k2(2)/(x-p1(2))+k2(3)/(x-p1(3))+k2(4)/(x-p1(4))+k2(5)/(x-p1(5));
end;
figure;
semilogx(f,abs(w1),f,abs(w2));
grid;
title('Sprawdzenie- |Zf0(w)|');
% [r,p,k]=residue(num,den)
% [q,r]=deconv(num,den)
% ala = fitsys(vabs(vaw0),5,wgtg,2)



