% program for presentation of the line frequency characteristic
% contained in *.lis file

clear all

    NEWL=abs([13 10]);
    [getfile,pat] = uigetfile('*.lis','Get Data File for Modification');
    if getfile == 0, return; end;
    k=size(pat);
    FILEPATH=pat(1:(k(2)-1));
    FILENAME=getfile;
    fid=fopen([pat getfile]);
    MFILE=fread(fid);
    MFILE=sprintf('%s',MFILE);
    k=findstr(MFILE,' Neper/km  ');
    l1=size(k,2);
    l2=size(MFILE,2);
    MFILE=MFILE(k(1,l1):l2);
    k=findstr(MFILE,NEWL);
    l1=size(k,2);
    l2=1;
    m=1;
    while l2,
     if l1>2,
       p=str2num(MFILE(k(1,m)+2:k(1,m+1)));
       if ~isempty(p),   
         nn(m,:)=p;
         m=m+1;
        else,
         l2=0;
       end;
      else,
       ['error'], return;
     end;
    end;
% Results:
%  --------------  Zero sequence  ----------------              -------------  Positive sequence  -------------
%    Alpha        Beta        R        L(milli-    C(micro-      Alpha        Beta        R        L(milli-    C(micro-    Frequency
% Neper/km    Radian/km    Ohm/km    Henry/km)   Farad/km)    Neper/km    Radian/km    Ohm/km     Henry/km)   Farad/km)       Hz
%
    ll=180;	% dlugosc linii
    k=size(nn,1);
k=find(exp(-ll*nn(:,1))<0.001);
k=k(1),
%nn=nn(1:k,:);
    f=nn(1:k,11);
    omg=2*pi*f;
    gg=0.03*1E-6;
    c0=nn(k,5);
    l0=nn(k,4);
    c1=nn(k,10);
    l1=nn(k,9);
    v0=1/sqrt(l0*c0*1E-9);
    v1=1/sqrt(l1*c1*1E-9);
    b00=ll*omg/v0;
    b01=ll*omg/v1;
    ta0=ll/v0;
    ta1=ll/v1;
 
     % A(w)
    j=sqrt(-1);
    aw0=exp(-(nn(1:k,1)+j*nn(1:k,2))*ll);
    z0=(nn(1:k,3)+j*omg.*nn(1:k,4)/1000);
%    y0=gg+j*omg.*nn(1:k,5)/1E6;
    y0=j*omg.*nn(1:k,5)/1E6;
    aw0=exp(-sqrt(z0.*y0)*ll);
    zf0=sqrt(z0./y0);
    aw1=exp(-(nn(1:k,6)+j*nn(1:k,7))*ll);
    z1=(nn(1:k,8)+j*omg.*nn(1:k,9)/1000);
    y1=j*omg.*nn(1:k,10)/1E6;
    zf1=sqrt(z1./y1);

    % charakterystyka amplitudy funkcji propagacji
    semilogx(f,abs(aw0),f,abs(aw1));
    title('|A(w)|');
    grid;
 
   % plotting korekta
    figure;
    % charakterystyka fazy funkcji propagacji po korekcji    
    semilogx(f,-(ll*nn(1:k,2)-b00)/pi,f,-(ll*nn(1:k,7)-b01)/pi);
    title('arg(A(w))');
    grid;

    % aproksymacja dla skladowej zerowej

figure;
wgt = 0.8;
wgtg = frsp(wgt,f);
wgtg=vpck(sqrt(abs(aw0)),f);		% wspolczynniki wagowe
vaw0=vpck(abs(aw0),f);
sysfit = fitmag(vabs(vaw0),wgtg);
[a,b,c,d]=unpck(sysfit);
[num,den]=ss2tf(a,b,c,d);

semilogx(f,abs(polyval(num,j*f)./polyval(den,j*f)));
grid;

% obliczanie zer i biegunw z num/den
z1=roots(num);
p1=roots(den);

gain=num(1)/den(1);
% sprawdzenie
sys2 = zp2sys(z1,p1,gain);
figure;
sysf = frsp(sys2,f);
msys=vunpck(sysf);
    semilogx(f,abs(aw0),f,abs(msys),f,abs(polyval(num,j*f)./polyval(den,j*f)));
    title('|A(w)|');

%vplot('liv,d',vabs(sysf));
grid;
figure;
  semilogx(f,-(ll*nn(1:k,2)-b00)/pi,f,angle(msys)/pi);
    title('arg(A(w))');
%vplot('liv,p',sysf);
grid;

	% obliczenie parametrw
	den1=den;
	[gain,num1]=deconv(num,den1);	% dzielenie licznika przez mianownik
	wym=size(num1,2)-1;		% liczba oczek RC
	z2=roots(num1);
	p2=p1;
	l2=size(p2,1);
	for i=1:l2,
	 li(i)=polyval(num1,p2(i));
	 mn(i)=1;
 	 for l=1:l2,
	  if l~=i,
	   mn(i)=mn(i)*(p2(i)-p2(l));
	  end; 
	 end;
	 k2(i)=li(i)/mn(i);
	 r2(i)=-k2(i)/p2(i);
	 c2(i)=1/k2(i);
	end;
	k2=k2(1:wym),
	r2=r2(1:wym),
	c2=c2(1:wym),
	gain,

% sprawdzenie
nw=size(nn(:,11),1);
for l=1:nw,
 f(l)=nn(l,11);
 x=j*f(l);
 w1(l)=polyval(num,x)/polyval(den,x);
 w2(l)=gain;
 for i=1:wym,
  w2(l)=w2(l)+k2(i)/(x-p2(i));
 end;
end;
figure;
semilogx(f,abs(w1),f,abs(w2));
grid;
figure;
omg=2*pi*nn(:,11);
    z0=(nn(:,3)+j*omg.*nn(:,4)/1000);
    y0=gg+j*omg.*nn(:,5)/1E6;
    aw0=exp(-sqrt(z0.*y0)*ll);
semilogx(f,abs(aw0),f,abs(w2));
grid;
% [r,p,k]=residue(num,den)
% [q,r]=deconv(num,den)
% ala = fitsys(vabs(vaw0),5,wgtg,2)



