% Program do obliczania macierzy transformacji ze wspolrzednych fazowych do wspolrzednych modalnych

clear all;

% macierz rezystancji
R=[7.161787E-02 4.331943E-02 4.185105E-02;
   4.331943E-02 7.258155E-02 4.331943E-02;
   4.185105E-02 4.331943E-02 7.161787E-02];

% macierz reaktancji, ohm/km
X=[4.594878E-01 1.448813E-01 1.082764E-01;
   1.448813E-01 4.494188E-01 1.448813E-01;
   1.082764E-01 1.448813E-01 4.594878E-01];
omg=100*pi;	% pulsacja

% macierz pojemnosci, F/km
C=[ 9.962258E-09 -1.526980E-09 -4.467067E-10;
   -1.526980E-09  1.026383E-08 -1.526980E-09;
   -4.467067E-10 -1.526980E-09  9.962258E-09];
Yc=omg*C*i;	% macierz susceptancji, S/km

% macierz parametrow
Ai=Yc*(R+X*i);
Au=(R+X*i)*Yc;

[Tu1,Vu]=eig(Au);
Ym=Tu1'*Yc*Tu1;
a1=(pi/2-angle(Ym(1,1)))/2;
a2=(pi/2-angle(Ym(2,2)))/2;
a3=(pi/2-angle(Ym(3,3)))/2;

Tu(:,1)=Tu1(:,1)*exp(i*a1);
Tu(:,2)=Tu1(:,2)*exp(i*a2);
Tu(:,3)=Tu1(:,3)*exp(i*a2);

Ym=diag([Ym(1,1),Ym(2,2),Ym(3,3)]);
Ti=Yc*Tu*inv(Ym);

Zm=diag([Vu(1,1)/Ym(1,1),Vu(2,2)/Ym(2,2),Vu(3,3)/Ym(3,3)]);
Zfm=diag([sqrt(Zm(1,1)/Ym(1,1)),sqrt(Zm(2,2)/Ym(2,2)),sqrt(Zm(3,3)/Ym(3,3))]);

Tu=real(Tu);
Ti=real(Ti);

Zf=Tu*Zfm*inv(Ti);








