 MODEL pq_1              -- pomiar mocy (P, Q, S) [VA] w ukladzie jednofazowym

     CONST
        N {VAL: 20}       -- liczba probek w okresie probkowania
        F {VAL: 50}       -- czestotliwosc sieci (Hz)

     VAR                  -- deklaracja zmiennych
        hc[1..N]          -- funkcja korelacyjna cos
        hs[1..N]          --                     sin
        kn                -- indeks numeru probki w oknie
        t_next            -- czas nastepnego probkowania [s]
        t_s               -- okres probkowania

        xvt[1..N]         -- przechowywane probki fazowe napiecia
        xit[1..N]         --                             pradu
        xpcv              -- cos/sin napiecia
        xpsv
        xpci              -- cos/sin pradu
        xpsi
        p_1               -- P
        q_1               -- Q
        s_1               -- S

     INPUT                -- Model inputs
        IN_V              -- sygnal wejsciowy napiecia
        IN_I              -- sygnal wejsciowy pradu

     INIT
      -- setting of the impulse function of the correlator
      t_s:=2*pi/N
      FOR j:=1 TO N DO
       hc[j]:=2*cos((j-1)*t_s)/N
       hs[j]:=2*sin((j-1)*t_s)/N
      ENDFOR
      kn:=1
      t_next:=0
      t_s:=1/(N*F)
      xvt[1..N]:=0
      xit[1..N]:=0
      xpcv:=0 xpsv:=0
      xpci:=0 xpsi:=0
     ENDINIT

    EXEC       -- pq_1
  ----- probkowanie -----
     IF abs(t-t_next)<(0.5*timestep) THEN
     -- obliczenie skladowych ortogonalnych
       xpcv:=xpcv+hc[kn]*(IN_V-xvt[N])        -- korelacja napiecia
       xpsv:=xpsv-hs[kn]*(IN_V-xvt[N])
       xpci:=xpci+hc[kn]*(IN_I-xit[N])        -- korelacja pradu
       xpsi:=xpsi-hs[kn]*(IN_I-xit[N])
     -- obliczanie mocy
       p_1:=(xpcv*xpci+xpsv*xpsi)/2
       q_1:=(xpsv*xpci-xpcv*xpsi)/2
       s_1:=norm(p_1,q_1)
       FOR j:=N TO 2 BY -1 DO              --memory shifting
        xvt[j]:=xvt[j-1]
        xit[j]:=xit[j-1]
       ENDFOR
       xvt[1]:=IN_V
       xit[1]:=IN_I
      t_next:=t_next+t_s
      kn:=kn+1
      IF kn>N THEN
       kn:=1
      ENDIF
     ENDIF
    ENDEXEC
   ENDMODEL -- pq_1
