% Exe1: resistance estimator

clear all;

fs=1000;	% sampling frequency
f1=50;		% nominal frequency
N=fs/f1;
nw=16;		% number of samples in data window
a=2*pi/N;

ww=2;
w=ones(1,ww)/ww;

C=5.0E-6;
L=0.15;
R=10;

Ts=1/fs;
fcir=183.66;	% circuit frequency
%fcir=50;	% circuit frequency
alf0=2*pi*fcir/tan(pi*fcir/fs);

alf0=2/Ts;
alf=alf0;
a1=alf*C;
a2=alf*a1*L;

om=1:499;
zs=R+i*((om.*om*L*C-1)./(om*C));

tt=alf*tan(om/alf);
zd=R+i*((L*C*tt.*tt-1)./(C*tt));


figure;
plot(om,abs(zs),om,abs(zd));grid;



