MODEL DFIG_V -- DFIG model with rotor voltage control
		-- diff. equations solved iteratively
		-- measurements and transformation convention: U=ual-j*ube; U=ud-j*uq; U=ux+j*uy

  DATA
      Lls		   -- stator inductance, H
      Llr		   -- rotor inductance, H
      Lm	           -- magnetizing inductance, H
      Rs	           -- stator resistance, ohm
      Rr	           -- rotor resistance, ohm
      pole_p		   -- number of pole pairs
      Vn		   -- nominal voltage, V
      slip		   -- initial rotor slip, %
      Rv                   -- resistance in the mechanical model, ohm
      Pnini		   -- iniatial active power, W
      Qnini		   -- initial reactive power, VA
      Tn1		   -- PI1 time constant (outer controller), s
      Tn2		   -- PI2 time constant (inner controller), s
      
  CONST 
      sqrt3 {VAL: sqrt(3)}
      omg_s {VAL: 100*PI}
      pi2   {VAL: 2*PI}
          
  INPUT 
      ISTAT[1..3]          -- stator currents
      VSTAT[1..3]          -- stator voltage
      IROTR[1..3]
      OMEG_R		   -- rotor angular velocity

  OUTPUT 
      VS_OUT[1..3]	   -- voltage source control
      T_WIND		   -- windmill moment

  VAR
      k_Pn
      th_r		   -- electrical angle of rotor position 
      Vs_al		   -- alpha-beta coordinates of stator voltage
      Vs_be
      Is_al		   -- alpha-beta coordinates of stator current
      Is_be

      Ts
      Tr
      sigm
      Xs
      Xm
      sigm1
      Trp
      Lrp
      Trps
      Trp1
      sTs
      Ts1
      Lm1
      Lrp1
      Lm1s
      s1om

      del_s

      Ps		   -- stator active power
      Qs
      Pr		   -- rotor active power
      Qr
      Pn		   -- machine active power at the network connection
      Qn

      gam_s

      Irxref		   -- reference rotor current in x-y coordinates
      Iryref

      omg_r		   -- rotor electrical angle velocity
      om_sl		   -- slip angle velocity
     
      Irx
      Iry
      Vrx		   -- rotor voltage in x-y coordinates
      Vry
      Isx
      Isy
      Ird
      Irq

      Ismq
      Ismd

      gam_sm	           -- phase of stator phase-linkage space vector

      Ism		   -- magnitude of stator phase-linkage space vector
      Vs		   -- magnitude of stator voltage
      Vs1

      Lsm
      Lrm
      Lr
      Ls
      Xsl

      KI_IX
      KI_IY
      KI_VX
      KI_VY
      Vprx
      Vpry

      Vdrx
      Vdry
      Vpra
      Vprb
      Vr_al
      Vr_be
      Ir_al
      Ir_be

      Is2
      ab
      aa
      ac

      a1
      a2
      a3
      a4

      Vsx
      Vsy

      VS_OUT[1..3]	  -- output voltage source
      T_WIND		  -- output windmill moment

      P_P[1..6]		  -- active power
      Q_Q[1..6]		  -- reactive power
      T_M[1..6]		  -- windmill torque 
      T_T[1..6]		  -- time
      P_nref		  -- reference power
      Q_nref
      TLini		  -- initial torque

      KP_1		  -- outer regulator settings
      KI_1
      KP_2		  -- inner regulator settings
      KI_2

  INIT

      k_Pn:=1		  -- stator and rotor power included

      Lr:=Llr+Lm
      Ls:=Lls+Lm
      Lsm:=Ls/Lm
 
      Xs:=omg_s*Ls
      Xm:=omg_s*Lm

      sigm:=1-Lm*Lm/(Ls*Lr)
      Ts:=Ls/Rs
      Tr:=Lr/Rr
      Trp:=sigm*Tr
      Lrp:=sigm*Lr
      sigm1:=(1-sigm)/sigm
      Trp1:=1/Trp
      Ts1:=1/Ts
      Trps:=Trp1+sigm1/Ts
      sTs:=sigm1/Ts
      Lm1:=1/Lm
      Lrp1:=1/Lrp
      Lm1s:=sigm1*Lm1

     -- regulators setting calculation
      KP_2:=sigm*Lr/Tn2
      KI_2:=Rr/Tn2

      KI_1:=3.0*Vn*SQRT(2.0)/(2*sqrt3*Lsm)

      KP_1:=(4*pi*Tn2/Tn1-1)/KI_1
      KI_1:=4*pi*pi*Tn2/(Tn1*Tn1*KI_1)

--      KI_1:=1/(Tn1*KI_1)
--      KP_1:=Tn2*KI_1


write('KP_1=',KP_1,' KI_1=',KI_1,' Tn1=',Tn1)
write('KP_2=',KP_2,' KI_2=',KI_2,' Tn2=',Tn2)

      P_nref:=Pnini
      Q_nref:=Qnini

     -- calculation of initial rotor position th_r
   
      Vs_al:=(2*VSTAT[1]-VSTAT[2]-VSTAT[3])/3     -- components of stator voltage space phasor
      Vs_be:=(VSTAT[3]-VSTAT[2])/sqrt3
      Vs:=norm(Vs_al,Vs_be)			  -- stator voltage
      histdef(Vs):=Vs

      Is_al:=(2*ISTAT[1]-ISTAT[2]-ISTAT[3])/3     -- components of stator current space phasor
      Is_be:=(ISTAT[3]-ISTAT[2])/sqrt3

      Ir_al:=(2*IROTR[1]-IROTR[2]-IROTR[3])/3     -- components of rotor current space phasor
      Ir_be:=(IROTR[3]-IROTR[2])/sqrt3

      aa:=(Xs*Is_al-Rs*Is_be-Vs_be)/Xm
      ab:=-(Xs*Is_be+Rs*Is_al+Vs_al)/Xm

  -- electrical angle of rotor
      th_r:=ATAN2((Ir_al*ab+Ir_be*aa),(Ir_al*aa-Ir_be*ab))

write('th_r=',th_r)
write('Ir_al=',Ir_al,' Ir_be=',Ir_be,' - from measurement')
write('Is_al=',Is_al,' Is_be=',Is_be,' - from measurement')

      -- initial Isx, Isy, Ism, Irx, Iry

      om_sl:=slip*omg_s/100
      omg_r:=omg_s-om_sl

      Is2:=Is_al*Is_al+Is_be*Is_be

      -- rotor power is included

      a1:=100*Lm/(slip*Lr)-(1+sigm)*Lsm		-- E
      a2:=2*Qnini/(3*om_sl*Lr)+sigm*Lsm*Lsm*Is2	-- F
      a3:=-2*Rs/(omg_s*Lm)			-- G
      a4:=Pnini+3*Is2*(Rs+Rr*Lsm*Lsm)/2		-- D
      Pn:=a3*a3/4
      Pn:=Pn*(Vs*Vs/(Rs*Rs)-Is2)		-- H
      aa:=3*Rr*Lsm				-- A
      ab:=3*Lm*omg_r/2				-- B
      ac:=3*Rr/2				-- C

      IF k_Pn=0 THEN
       a1:=omg_s*Lm
       a2:=-2*Qnini/3
       a4:=Pnini+3*Is2*Rs/2
       aa:=0
       ab:=3*a1/2
       ac:=0
      ENDIF

      Qn:=aa*a3-ab*a1-ac*a1*a3
      Ism:=(a4*a1*a3-a2*aa*a3-Pn*ab*a1)/Qn	-- Ism2

      Isx:=(a2+k_Pn*Ism)/a1			-- alpha
      Isy:=(Pn-Ism)/a3				-- beta

      Ism:=sqrt(Ism)
      Isx:=Isx/Ism
      Isy:=Isy/Ism
      Irx:=Ism+Lsm*Isx
      Iry:=Lsm*Isy

      -- calculation of the angle gam_sm
      aa:=cos(th_r)
      ac:=-sin(th_r)

      Ird:=(aa*Ir_al-ac*Ir_be)
      Irq:=(-ac*Ir_al-aa*Ir_be)

      Ismq:=Irq+Lsm*Is_be
      Ismd:=Ird-Lsm*Is_al

      gam_sm:=ATAN2(Ismq,Ismd)

      del_s:=ATAN2(-Vs_be,Vs_al)-gam_sm
      Vsx:=Vs*cos(del_s)
      Vsy:=Vs*sin(del_s)

write('Vs_be=',Vs_be,' Vs_al=',Vs_al,' del_s=',del_s,' gam_sm=',gam_sm)
write('Isx=',Isx,' Isy=',Isy,' Isxy=',sqrt(Isx*Isx+Isy*Isy))
write('Is_be=',Is_be,' Is_al=',Is_al,' Isab=',sqrt(Is_al*Is_al+Is_be*Is_be))


      histdef(om_sl):=om_sl


histdef(Isx):=Isx
histdef(Isy):=Isy


      histdef(Irx):=Irx
      histdef(Iry):=Iry
      histdef(Vsx):=Vsx
      histdef(Vsy):=Vsy
      histdef(Ism):=Ism
      histdef(gam_sm):=gam_sm
      histdef(del_s):=del_s

write('Irx=',Irx,' Iry=',Iry,' Ism=',Ism)
write('Vsx=',Vsx,' Vsy=',Vsy,' gam_sm=',gam_sm)

      -- stator power
      Ps:=3*Vs*Iry/(2*Lsm)
      Qs:=3*Vs*(Irx-Ism)/(2*Lsm)

      histdef(KI_IX):=Irx+KP_1*Qnini
      histdef(KI_IY):=Iry+KP_1*Pnini
      histdef(KI_VX):=Rr*Irx
      histdef(KI_VY):=Rr*Iry

      s1om:=sigm1*om_sl

      Xsl:=om_sl*Lrp
      Vrx:=Rr*Irx-Xsl*Iry
      Vry:=Rr*Iry+om_sl*Lm*Ism/Lsm+Xsl*Irx

write('Vrx=',Vrx,' Vry=',Vry,' om_sl=',om_sl)
     
      histdef(a1):=Irx*Ts1+Vsx*Lm1
      histdef(a2):=(Iry*Ts1+Vsy*Lm1)*recip(Ism)
      histdef(a3):=Vrx*Lrp1+om_sl*Iry+sTs*Ism-Vsx*Lm1s
      histdef(a4):=Vry*Lrp1-om_sl*Irx-s1om*Ism

      -- calculation of needed rotor current source
      ab:=gam_sm-th_r
      aa:=cos(ab)
      ac:=sin(ab)
      Ir_al:=Irx*aa-Iry*ac			-- Ir_al
      Ir_be:=-(Irx*ac+Iry*aa)			-- Ir_be
write('Ir_al=',Ir_al,' Ir_be=',Ir_be,' - estimated')
      ac:=Irx*Irx+Iry*Iry
      aa:=sqrt(ac)			-- needed current magnitude in the current source
      ab:=180*atan2(Ir_be,Ir_al)/pi	-- needed current angle

write('|Ir|=',aa,' angle=',ab)

      -- rotor power
      Pr:=-3*(Vrx*Irx+Vry*Iry)/2
      Qr:=-3*(Vry*Irx-Vrx*Iry)/2

      Pn:=Ps
      Qn:=Qs
      -- initial load torque
      TLini:=0
      IF k_Pn THEN
        Pn:=Ps+Pr
        Qn:=Qs+Qr
        TLini:=-3*pole_p*(Rr*ac)/(2*omg_r)
      ENDIF
      TLini:=TLini+pole_p*Pn/omg_r-omg_r/(pole_p*Rv)-3*pole_p*(Rs*Is2)/(2*omg_r)

write('Ps=',Ps,' Qs=',Qs)
write('Pr=',Pr,' Qr=',Qr,' Vs=',Vs)

write('Te=',pole_p*Pn/omg_r)
write('Tv=',omg_r/(pole_p*Rv))
write('TRs=',3*pole_p*(Rs*Is2)/(2*omg_r))
write('TRr=',3*pole_p*(Rr*ac)/(2*omg_r))
-- TL_ini should be put into the machine mechanical model
write('T_Lini=',-TLini)
T_WIND:=0

      P_P[1..6]:=[Pnini, Pnini, 1800000, 2000000, 1200000, Pnini]
      Q_Q[1..6]:=[Qnini, Qnini, -1400000, -1500000, -600000, Qnini]
      T_M[1..6]:=[T_WIND, T_WIND, 2000.0, 5000.0, 1500.0, 1400.0]

      T_T[1..6]:=[0.0, 1.0, 4.0, 4.5, 7.0, 10.0]	-- time table, s

--      P_P[1..6]:=[Pnini, Pnini, Pnini, Pnini, Pnini, Pnini]
--      Q_Q[1..6]:=[Qnini, Qnini, Qnini, Qnini, Qnini, Qnini]

      T_T[1..6]:=[0.0, 1.0, 4.0, 4.5, 7.0, 10.0]	-- time table, s
  ENDINIT

--

  EXEC                     -- DFIG_V
  -- main procedure

  -- looking for current value of power
  IF t>=T_T[6] THEN
   P_nref:=P_P[6]
   Q_nref:=Q_Q[6]
   T_WIND:=T_M[6]
   ELSIF t>=T_T[5] THEN
    P_nref:=P_P[5]
    Q_nref:=Q_Q[5]
    T_WIND:=T_M[5]
    ELSIF t>=T_T[4] THEN
     P_nref:=P_P[4]
     Q_nref:=Q_Q[4]
     T_WIND:=T_M[4]
     ELSIF t>=T_T[3] THEN
      P_nref:=P_P[3]
      Q_nref:=Q_Q[3]
      T_WIND:=T_M[3]
      ELSIF t>=T_T[2] THEN
       P_nref:=P_P[2]
       Q_nref:=Q_Q[2]
       T_WIND:=T_M[2]
  ENDIF

   omg_r:=pole_p*OMEG_R				-- rotor electrical speed

   Vs_al:=(2*VSTAT[1]-VSTAT[2]-VSTAT[3])/3      -- components of stator voltage space phasor
   Vs_be:=(VSTAT[3]-VSTAT[2])/sqrt3               

   Is_al:=(2*ISTAT[1]-ISTAT[2]-ISTAT[3])/3      -- components of stator current space phasor
   Is_be:=(ISTAT[3]-ISTAT[2])/sqrt3
  
   Vs1:=norm(Vs_al,Vs_be)
   LAPLACE (Vs/Vs1) := 1| / (1|s0+0.0002|s1)	-- smoothing

-- calculation of rotor position

   Ir_al:=(2*IROTR[1]-IROTR[2]-IROTR[3])/3     -- components of rotor current space phasor
   Ir_be:=(IROTR[3]-IROTR[2])/sqrt3

   aa:=(Xs*Is_al-Rs*Is_be-Vs_be)/Xm
   ab:=-(Xs*Is_be+Rs*Is_al+Vs_al)/Xm

  -- electrical angle of rotor
   th_r:=ATAN2((Ir_al*ab+Ir_be*aa),(Ir_al*aa-Ir_be*ab))

-- calculation of the stator voltage angle

   gam_s:=ATAN2(-Vs_be,Vs_al)

   om_sl:=omg_s-omg_r				-- slip calculation
   s1om:=sigm1*om_sl

  COMBINE ITERATE {7} AS first_group
   -- iterative calculation of main x-y model
   del_s:=gam_s-gam_sm
   Vsx:=Vs*cos(del_s)
   Vsy:=Vs*sin(del_s)
   -- solution of differential equations
    a1:=Irx*Ts1+Vsx*Lm1
    laplace (Ism/a1) := Ts| / (1|s0+Ts|s1)
    a2:=(Iry*Ts1+Vsy*Lm1)*recip(Ism)
    laplace (gam_sm/a2) := 1| / (0|s0+1|s1)
    a3:=Vrx*Lrp1+om_sl*Iry+sTs*Ism-Vsx*Lm1s
    laplace (Irx/a3) := 1| / (Trps|s0+1|s1)
    a4:=Vry*Lrp1-om_sl*Irx-s1om*Ism
    laplace (Iry/a4) := 1| / (Trp1|s0+1|s1)
   --
  ENDCOMBINE

  IF del_s<-pi THEN
    del_s:=del_s+pi2
  ENDIF

  IF gam_sm>pi THEN
    gam_sm:=gam_sm-pi2
  ENDIF


-- for placing into *.pl4 and viewing only
Isx:=(Ism-Irx)/Lsm
Isy:=-Iry/Lsm


  -- Power PI_1 regulator: outer control-loop

   Irxref:=(Q_nref-Qn)
   Iryref:=(P_nref-Pn)

   laplace (KI_IX/Irxref) := KI_1| / (0|s0+1|s1)
   Irxref:=KI_IX-KP_1*Qn

   laplace (KI_IY/Iryref) := KI_1| / (0|s0+1|s1)
   Iryref:=KI_IY-KP_1*Pn

   -- Voltage PI_2 regulator: inner control loop

   Vpra:=Irxref-Irx
   Vprb:=Iryref-Iry

   laplace (KI_VX/Vpra) := KI_2| / (0|s0+1|s1)
   Vprx:=KP_2*Vpra+KI_VX

   laplace (KI_VY/Vprb) := KI_2| / (0|s0+1|s1)
   Vpry:=KP_2*Vprb+KI_VY

   Xsl:=om_sl*Lrp
   Vdrx:=-Xsl*Iry
   Vdry:=Xsl*(sigm1*Ism+Irx)

   Vry:=Vdry+Vpry
   Vrx:=Vdrx+Vprx

   -- power determination
   Ps:=3*Vs*Iry/(2*Lsm)
   Qs:=3*Vs*(Irx-Ism)/(2*Lsm)

   Pr:=-3*(Vrx*Irx+Vry*Iry)/2
   Qr:=-3*(Vry*Irx-Vrx*Iry)/2

   Pn:=Ps+Pr
   Qn:=Qs+Qr

   -- output control voltage
   ab:=gam_sm-th_r
   aa:=cos(ab)
   ac:=sin(ab)
   Vr_al:=(Vrx*aa-Vry*ac)        	          -- output rotor voltage in al-bet coordinates
   Vr_be:=-(Vrx*ac+Vry*aa)

   VS_OUT[1]:=Vr_al				  -- output rotor voltage in phase coordinates
   VS_OUT[2]:=-(sqrt3*Vr_be+Vr_al)/2
   VS_OUT[3]:=(sqrt3*Vr_be-Vr_al)/2
 
  ENDEXEC

 ENDMODEL                  -- DFIG_V
