MODEL flt_prim -- nonlinear fault model for one phase fault, primary arc model

-- '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
-- * Model of the Primary Arc (i.e. before breaker openning)         
-- * WUT, Wroclaw, June 1997                                                 
-- * References:                                                             
-- * 1. Y.H. Song, R.K. Aggarwal, A.T. Jones, Digital Simulation of Fault    
-- *  Arcs Long-Distance Compensated Transmission Systems with Particular     
-- *  Reference to Adaptive Autoreclose, ETEP, Vol. 5, No. 5. Sept/Oct 1995   
-- *  pp.315-324                                                              
-- * 2. M. Kizilcay, T. Pniok, Digital Simulation of Fault Arcs
-- *  Power Systems, ETEP, Vol. 1, No. 1, Jan/Feb. 1991, pp.55-60
-- '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

  CONST 
      ip   {VAL: 15.e3}    -- peak arc current [A]
      up   {VAL: 15.}      -- arc voltage drop [V/cm]
      alf0 {VAL: 2.5e-5}   -- time constant coefficient
      R    {VAL: 1.e-5}    -- arc resistance [ohm/cm]
  DATA
      arc_l                -- arc length [cm]
  INPUT 
      ufr                  -- 
      ifr                  -- 
  OUTPUT
      r_res                -- arc resistance
  VAR 
      r_res         
      Gp                   -- stationary arc conductance [mho]
      g1                   -- dynamic arc conductance in k step
      go                   -- dynamic arc conductance in k+1 step
      Tp
      alf
      gm
  INIT                     -- initialization at t=0 
      
      Tp:=alf0*ip/arc_l            -- arc dynam .equ. time constant
      alf:=exp(-timestep/Tp)    -- dyn.eq.coeff.
      gm:=0.27*ip/(5.0*up*arc_l)   -- initial value of the dynamic arc conductance
      go:=gm
      r_res:=1/go
  ENDINIT

  EXEC                     -- flt_prim
  -- Model represents only stationary arc

   IF abs(ifr)>0 THEN
     Gp:=abs(ifr)/((up+R*abs(ifr))*arc_l)
     g1:=(1-alf)*Gp+go*alf
     r_res:=1/g1
     go:=g1
    ELSE
     r_res:=1/gm
   ENDIF
 ENDEXEC
 ENDMODEL                  -- flt_prim
