MODEL RE_CNT -- model of shunt reactor control system


  DATA
      V_nom
      K_P
      K_I

  CONST 
      N     {VAL: 20}	
      sqrt3 {VAL: sqrt(3)}
      vmax  {VAL: 175}	   -- limits for fire angle
      vmin  {VAL: 5}

  INPUT 
      IN_V3[1..3]          -- shunt reactor voltage

  OUTPUT 
      TH_CP[1..3]          -- thiristor fire signal (+)
      TH_CN[1..3]          -- thiristor fire signal (-)

  VAR 
      V1P		   -- measured voltage
      V1PS
      TH_CP[1..3]
      TH_CN[1..3]
      vrsq[1..3]	   -- needed for angle calculation
      th0[1..3]
      v_in[1..3]
      f_angl		   -- fire angle
      sig
      in1
      f_a
      err

   C_P
   C_N
   TH_A

  HISTORY
      V1P {dflt:V_nom}
      f_a {dflt:150.0}
      v_in[1..3] {dflt:[0 0 0]}
     
  INIT
      V1P:=0;              	-- initial condition, t=0 
      f_a:=150
      histdef(vrsq[1..3]):=0    -- needed for deriv() calculation
      in1:=100.0*PI*timestep
      th0[1..3]:=0.0
      f_angl:=0
  ENDINIT

  EXEC                     -- RE_CNT
  -- main procedure

   laplace (v_in[1]/IN_V3[1]) := 1| / (1|s0+0.0001|s1)		-- filtering
   laplace (v_in[2]/IN_V3[2]) := 1| / (1|s0+0.0001|s1)		-- filtering
   laplace (v_in[3]/IN_V3[3]) := 1| / (1|s0+0.0001|s1)		-- filtering


   V1PS:=SQRT(v_in[1]*v_in[1]+v_in[2]*v_in[2]+v_in[3]*v_in[3])

   laplace (V1P/V1PS) := 1| / (1|s0+0.01|s1)		-- measurement filtering

-- Regulator
   err:=V_nom-V1P					-- error signal

   laplace (f_a/err){DMAX:vmax  DMIN:vmin}:=(K_I|s0+K_P|s1)/(0|s0+1|s1)		-- regulator PI
--   
   f_angl:=PI*f_a/180					-- fire angle

   FOR i:=1 TO 3 DO   
    vrsq[i]:=sign(v_in[i])     -- sign of phase voltage
    sig:=abs(vrsq[i]-prevval(vrsq[i]))/timestep

    IF sig>0.0 THEN
      th0[i]:=0.0		-- saw-form phase signal
     ELSE
      IF IN_V3[i]>0 THEN
        th0[i]:=th0[i]+in1
       ELSE
        th0[i]:=th0[i]-in1
      ENDIF
    ENDIF
    
    TH_CP[i]:=0			-- 'positive' thiristor control signal
    TH_CN[i]:=0			-- 'negative' thiristor control signal
    IF th0[i]>=f_angl THEN
      TH_CP[i]:=1
     ELSE
      IF th0[i]<-f_angl THEN
       TH_CN[i]:=1
      ENDIF
    ENDIF

   ENDFOR	-- FOR i:=1 TO 3

TH_A:=th0[1]


C_P:=TH_CP[1]
C_N:=TH_CN[1]

   ENDEXEC
 ENDMODEL                  -- RE_CNT
